//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// IAPointSearch.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72

#ifndef _IA_POINT_SEARCH_H
#define _IA_POINT_SEARCH_H

#include "RRProcess.h"
#include "RRFileListData.h"
#include "RRGridArrayData.h"
//#include "RRImage.h"
#include "RRField.h"
#include "RRPixelD.h"

class IAPointSearch : public RRProcess
{
  private:

	int mTemplateSize;
	int mSearchSize;

  private:

	RRStatus mfOnePointSearch(
			//const RRImage& ref,
			const RRField< RRPixelD >& ref,
			//const RRImage& dest,
			const RRField< RRPixelD >& dest,
			const RRGrid2& rp,
			RRGrid2& dp);

  public:

    IAPointSearch(
			const RRArray< RRData* >& in,	// RRFileListData  -> in[0]
											// RRGridArrayData -> in[1]				
			RRData *out,	                // RRGridArrayData
			const int templatesize,
			const int searchsize);

	RRStatus doIt();
};

#endif // _IA_POINT_SEARCH_H

//-------------------------------------------------------------------=72
// End of IAPointSearch.h
//-------------------------------------------------------------------=72
