//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// IAPointSearch.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72

#include "IAPointSearch.h"
#include "IATempMatch.h"
#include "RRImageFileIO.h"

#include <math.h>
#include <stdio.h>

IAPointSearch::IAPointSearch(
			const RRArray< RRData* >& in,	// RRFileListData  -> in[0]
											// RRGridArrayData -> in[1]				
			RRData *out,	                // RRGridArrayData
			const int templatesize,
			const int searchsize)
:RRProcess("IAPointSearch",in,out),
 mTemplateSize(templatesize),
 mSearchSize(searchsize)
{}

RRStatus IAPointSearch::mfOnePointSearch(
			//const RRImage& ref,
			const RRField< RRPixelD >& ref,
			//const RRImage& dest,
			const RRField< RRPixelD >& dest,
			const RRGrid2& rp,
			RRGrid2& dp)
{
    //RRImage tempalteimg;
	RRField< RRPixelD > tempalteimg;

    RRGrid2 templateorigin;
	templateorigin.setX(rp.getX()-mTemplateSize/2);
  	templateorigin.setY(rp.getY()-mTemplateSize/2);
	if(RRUtilTempMatch::getSubImage(ref,
	                           templateorigin.getX(),
	                           templateorigin.getY(),
					           mTemplateSize,
					           mTemplateSize,
					           tempalteimg)==RR_ERROR)
		return RR_ERROR;

	//RRImage searchareaimg;
	RRField< RRPixelD > searchareaimg;

	RRGrid2 searchareaorigin;
	searchareaorigin.setX(rp.getX()-(mSearchSize+mTemplateSize)/2);
  	searchareaorigin.setY(rp.getY()-(mSearchSize+mTemplateSize)/2);
    if(RRUtilTempMatch::getSubImage(dest,
	                           searchareaorigin.getX(),
	                           searchareaorigin.getY(),
					           mSearchSize+mTemplateSize,
					           mSearchSize+mTemplateSize,
					           searchareaimg)==RR_ERROR)
		return RR_ERROR;

	int matchx,matchy;
	double mse;
	if(RRUtilTempMatch::templateMatching(tempalteimg,
	                             searchareaimg,
								 matchx,
								 matchy,
								 mse)==RR_ERROR)
		return RR_ERROR;

	dp.setX(matchx+searchareaorigin.getX()+mTemplateSize/2);
	dp.setY(matchy+searchareaorigin.getY()+mTemplateSize/2);

	return RR_SUCCESS;
}

RRStatus IAPointSearch::doIt()
{
	RRFileListData& imary=(RRFileListData&)(mInput[0]->getSubstance());
	RRGridArrayData& grary=(RRGridArrayData&)(mInput[1]->getSubstance());
    RRGridArrayData& out=(RRGridArrayData&)(mOutput->getSubstance());

	//RRROBMPImage ref(imary.getImageName(0));
	//RRROBMPImage dest(imary.getImageName(1));
	RRField< RRPixelD > ref,dest;
	if(RRImageFileIO::load(imary.getFileName(0),RRIFIO_EXT,RRIFIO_PIXELD,ref)==RR_ERROR)
			return RR_ERROR;
	if(RRImageFileIO::load(imary.getFileName(1),RRIFIO_EXT,RRIFIO_PIXELD,dest)==RR_ERROR)
			return RR_ERROR;

	const RRArray< RRGrid2 >& rp=grary.getGridArray();
	RRArray< RRGrid2 > dp(rp.getSize());

	for(int i=0;i<rp.getSize();i++)
		if(mfOnePointSearch(ref,dest,rp[i],dp[i])==RR_ERROR)
			return RR_ERROR;

	out.setGridArray(dp);
	return RR_SUCCESS;
}

//-------------------------------------------------------------------=72
// End of IAPointSearch.cpp
//-------------------------------------------------------------------=72

