//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// IAMobileRectHandler.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72
// IAMobileRectHandler is a RRMobileRectHandler.
// IAMobileRectHandler is the event handler for 
// IAMatchingPoint.
//-------------------------------------------------------------------=72

#ifndef _IA_MOBILE_RECT_HANDLER_H
#define _IA_MOBILE_RECT_HANDLER_H

#include "RRMobileRectHandler.h"
#include "IAMobileRect.h"
#include "IAViewUserDefinePart.h"
#include "IAMatchingPoint.h"

class IAMobileRectHandler : public RRMobileRectHandler
{
  private:
  
	IAMobileRect *mGraphic;
	// OpenGL object of IAMatchingPoint

	IAViewUserDefinePart *mView;
	// View window of ImageAlignment
		
	IAMatchingPoint *mMatchingPoint;
	// IAMatchingPoint data object

  	RRGrid2 mGrabbedPtr; 
	// Cache of grabbed position

  protected:
    	
  	virtual RRStatus mfSelectedAction(const RREvent& e);
  	// Called when this handle is selected.
  	
  	virtual RRStatus mfUnselectedAction(const RREvent& e);
  	// Called when this handle is unselected.
  	
  	virtual RRStatus mfGrabbedAction(const RREvent& e);
  	// Called when this handle is grabbed.
  	
  	virtual RRStatus mfUngrabbedAction(const RREvent& e);
  	// Called when this handle is ungrabbed.
  	
  	virtual RRStatus mfDraggedAction(const RREvent& e);
  	// Called when this handle is dragged.
    	
 public:
  
  	IAMobileRectHandler(
			RREventHandler *pa,
			IAMatchingPoint *mp,
			IAMobileRect *graph,
			IAViewUserDefinePart *view);
  	// Every IAMobileRectHandler must be constructed with a certain parent.
  	 
  	IAMobileRectHandler(
			const IAMobileRectHandler& x);
  	
  	virtual ~IAMobileRectHandler();
  	
  	const IAMobileRectHandler& operator=(
			const IAMobileRectHandler& x);

	IAMobileRect *getGraphic()const{return mGraphic;}
	IAMatchingPoint *getMatchingPoint()const{return mMatchingPoint;}
};
    
#endif // _IA_MOBILE_RECT_HANDLER_H

//-------------------------------------------------------------------=72
// End of IAMobileRectHandler.h
//-------------------------------------------------------------------=72
