//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// IAMobileRectHandler.C
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72

#include "stdafx.h"

#include "IAMobileRectHandler.h"

const int IAMRH_SELECT_MARGIN = 1;

RRStatus IAMobileRectHandler::mfSelectedAction(
			const RREvent& e)
{
	RRStatus status=RRMobileRectHandler::mfSelectedAction(e);

	mGraphic->changeColorSelected();
	mView->scissorRect(mGraphic);
	mView->onDraw();
	return status;
}
  	
RRStatus IAMobileRectHandler::mfUnselectedAction(
			const RREvent& e)
{
	RRStatus status=RRMobileRectHandler::mfUnselectedAction(e);

	mGraphic->changeColorUnselected();	
	mView->scissorRect(NULL);
	mView->onDraw();
	return status;
}
  	
RRStatus IAMobileRectHandler::mfGrabbedAction(
			const RREvent& e)
{
	mGrabbedPtr=e.pos;
	return RRMobileRectHandler::mfGrabbedAction(e);
}
  	
RRStatus IAMobileRectHandler::mfUngrabbedAction(
			const RREvent& e)
{
	return RRMobileRectHandler::mfUngrabbedAction(e);
}
  	
RRStatus IAMobileRectHandler::mfDraggedAction(
			const RREvent& e)
{
	RRStatus status=RRMobileRectHandler::mfDraggedAction(e);
	
	mMatchingPoint->move(e.pos-mGrabbedPtr);
	mGrabbedPtr=e.pos;

	RRBoundingBox& bbox=mfGetBBox();
	bbox=RRBoundingBox(mMatchingPoint->getRectBL(),
	                    mMatchingPoint->getRectTR(),
						IAMRH_SELECT_MARGIN);

	mGraphic->move();

	mView->scissorRect(mGraphic);
	mView->onDraw();
	return status;
}
  
  	
IAMobileRectHandler::IAMobileRectHandler(
			RREventHandler *pa,
			IAMatchingPoint *mp,
			IAMobileRect *graph,
			IAViewUserDefinePart *view)
:RRMobileRectHandler(pa,RRGrid2(),RRGrid2(),IAMRH_SELECT_MARGIN),
 mMatchingPoint(mp),
 mGraphic(graph),
 mView(view)
{
	RRBoundingBox& bbox=mfGetBBox();
	bbox=RRBoundingBox(mp->getRectBL(),
	                    mp->getRectTR(),
						IAMRH_SELECT_MARGIN);
	mfSetBL(mp->getRectBL());
	mfSetTR(mp->getRectTR());
}
  	 
IAMobileRectHandler::IAMobileRectHandler(
			const IAMobileRectHandler& x)
:RRMobileRectHandler(x),
 mMatchingPoint(x.mMatchingPoint),
 mGraphic(x.mGraphic),
 mView(x.mView)
{}
  	
IAMobileRectHandler::~IAMobileRectHandler()
{}
  	
const IAMobileRectHandler& IAMobileRectHandler::operator=(
			const IAMobileRectHandler& x)
{
	RRMobileRectHandler::operator=(x);
	mMatchingPoint=x.mMatchingPoint;
	mGraphic=x.mGraphic;
	mView=x.mView;
	return *this;
}
    
//-------------------------------------------------------------------=72
// End of IAMobileRectHandler.C
//-------------------------------------------------------------------=72
