//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// IAMobileRect.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72
// IAMobileRect is a WGLObject which is the graphical image
// of IAMatchingPoint. 
//-------------------------------------------------------------------=72

#ifndef _IA_MOBIE_RECT_H
#define _IA_MOBIE_RECT_H

#include "WGLObject.h"
#include "IAMatchingPoint.h"

extern const float IAMR_SELECTED_COLOR[4];
extern const float IAMR_UNSELECTED_COLOR[4];

class IAMobileRect : public WGLObject
{
  private:

	IAMatchingPoint *mMatchingPoint;
	RRGrid2 mBL,mTR;
	float mColor[4];

  public:

	IAMobileRect(IAMatchingPoint *mp);
	IAMobileRect(const IAMobileRect& x);
	virtual ~IAMobileRect();
	
	const IAMobileRect& operator=(const IAMobileRect& x);

	virtual bool renderObject()const;

	void setColor(const float col[]);
	void changeColorSelected();
	void changeColorUnselected();

	void move();
	// move to the position of mMatchingPoint
};

#endif // _IA_MOBIE_RECT_H

//-------------------------------------------------------------------=72
// End of IAMobileRect.h
//-------------------------------------------------------------------=72
