//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// IAMobileRect.C
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72

#include "stdafx.h"
#include "IAMobileRect.h"

const float IAMR_SELECTED_COLOR[4] = {1.,1.,0.,1.};
const float IAMR_UNSELECTED_COLOR[4] = {1.,1.,1.,1.};

const int IAMR_REDRAW_MARGIN = 1;

IAMobileRect::IAMobileRect(IAMatchingPoint *mp)
:WGLObject(),
 mBL(mp->getRectBL()),
 mTR(mp->getRectTR()),
 mMatchingPoint(mp)
{
	mfSetBBox(RRBoundingBox(mBL,mTR,IAMR_REDRAW_MARGIN));
	mColor[0]=IAMR_UNSELECTED_COLOR[0];
	mColor[1]=IAMR_UNSELECTED_COLOR[1];
	mColor[2]=IAMR_UNSELECTED_COLOR[2];
	mColor[3]=IAMR_UNSELECTED_COLOR[3];
}

IAMobileRect::IAMobileRect(
			const IAMobileRect& x)
:WGLObject(x),
 mBL(x.mBL),
 mTR(x.mTR),
 mMatchingPoint(x.mMatchingPoint)
{
	mColor[0]=x.mColor[0];
	mColor[1]=x.mColor[1];
	mColor[2]=x.mColor[2];
	mColor[3]=x.mColor[3];
}

IAMobileRect::~IAMobileRect()
{}

const IAMobileRect& IAMobileRect::operator=(
			const IAMobileRect& x)
{
	WGLObject::operator=(x);
	mMatchingPoint=x.mMatchingPoint;
	mBL=x.mBL;
	mTR=x.mTR;
	mColor[0]=x.mColor[0];
	mColor[1]=x.mColor[1];
	mColor[2]=x.mColor[2];
	mColor[3]=x.mColor[3];
	return *this; 
}

void IAMobileRect::setColor(
			const float col[])
{
	mColor[0]=col[0];
	mColor[1]=col[1];
	mColor[2]=col[2];
	mColor[3]=col[3];
}

void IAMobileRect::changeColorSelected()
{
	mColor[0]=IAMR_SELECTED_COLOR[0];
	mColor[1]=IAMR_SELECTED_COLOR[1];
	mColor[2]=IAMR_SELECTED_COLOR[2];
	mColor[3]=IAMR_SELECTED_COLOR[3];
}

void IAMobileRect::changeColorUnselected()
{
	mColor[0]=IAMR_UNSELECTED_COLOR[0];
	mColor[1]=IAMR_UNSELECTED_COLOR[1];
	mColor[2]=IAMR_UNSELECTED_COLOR[2];
	mColor[3]=IAMR_UNSELECTED_COLOR[3];
}

bool IAMobileRect::renderObject()const
{
	glPushMatrix();
	{
		glColor4fv(mColor);
		glBegin(GL_LINE_LOOP);
		glVertex2i(mBL.getX(),mBL.getY());
		glVertex2i(mTR.getX(),mBL.getY());
		glVertex2i(mTR.getX(),mTR.getY());
		glVertex2i(mBL.getX(),mTR.getY());
		glEnd();
	}
	glPopMatrix();

	return true;
}

void IAMobileRect::move()
{
	mBL=mMatchingPoint->getRectBL();
	mTR=mMatchingPoint->getRectTR();
	mfSetBBox(RRBoundingBox(mBL,mTR,IAMR_REDRAW_MARGIN));
}

//-------------------------------------------------------------------=72
// End of IAMobileRect.C
//-------------------------------------------------------------------=72
