//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// IAMatchingPoint.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72
// IAMatchingPoint is a mobile rectangle data object.
// IAMatchingPoint consist of the position of center
// (mPosition) and the width of rectangle (mWidth).
//-------------------------------------------------------------------=72

#ifndef _IA_MATCHING_POINT_H
#define _IA_MATCHING_POINT_H

#include "RRGrid2.h"

extern const int IAMP_D_WIDTH;

class IAMatchingPoint
{
  private:

	RRGrid2 mPosition;
	int mWidth;

  public:

	IAMatchingPoint();
	IAMatchingPoint(
			const RRGrid2& pos,
			const int width);
	IAMatchingPoint(
			const int px,
			const int py,
			const int width);
	IAMatchingPoint(const IAMatchingPoint& x);
	virtual ~IAMatchingPoint();
	
	const IAMatchingPoint& operator=(const IAMatchingPoint& x);

	RRGrid2 getPosition()const{return mPosition;}
	void getPosition(
			int& px,
			int& py)const;
	void setPosition(
			const RRGrid2& pos);
	void setPosition(
			const int px,
			const int py);

	int getWidth()const{return mWidth;}
	void setWidth(const int width);

	RRGrid2 getRectBL()const;
	RRGrid2 getRectTR()const;

	void move(const RRGrid2& dif);
	// move postion from mPostion to mPosition+dif
};

#endif // _IA_MATCHING_POINT_H

//-------------------------------------------------------------------=72
// End of IAMatchingPoint.h
//-------------------------------------------------------------------=72
