//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// IAMatchingPoint.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72

#include "stdafx.h"

#include "IAMatchingPoint.h"

const int IAMP_D_WIDTH = 32;

IAMatchingPoint::IAMatchingPoint()
:mPosition(0,0),
 mWidth(IAMP_D_WIDTH)
{}

IAMatchingPoint::IAMatchingPoint(
			const RRGrid2& pos,
			const int width)
:mPosition(pos),
 mWidth(width)
{}

IAMatchingPoint::IAMatchingPoint(
			const int px,
			const int py,
			const int width)
:mPosition(px,py),
 mWidth(width)
{}

IAMatchingPoint::IAMatchingPoint(
			const IAMatchingPoint& x)
:mPosition(x.mPosition),
 mWidth(x.mWidth)
{}

IAMatchingPoint::~IAMatchingPoint()
{}
	
const IAMatchingPoint& IAMatchingPoint::operator=(
			const IAMatchingPoint& x)
{
	mPosition=x.mPosition;
	mWidth=x.mWidth;
	return *this;
}

void IAMatchingPoint::getPosition(
			int& px,
			int& py)const
{
	px=mPosition.getX();
	py=mPosition.getY();
}

void IAMatchingPoint::setPosition(
			const RRGrid2& pos)
{
	mPosition=pos;
}

void IAMatchingPoint::setPosition(
			const int px,
			const int py)
{
	mPosition=RRGrid2(px,py);
}

void IAMatchingPoint::setWidth(
			const int width)
{
	mWidth=width;
}

RRGrid2 IAMatchingPoint::getRectBL()const
{
	return mPosition-RRGrid2(int(mWidth*0.5+0.5),
	                          int(mWidth*0.5+0.5));
}

RRGrid2 IAMatchingPoint::getRectTR()const
{
	return mPosition+RRGrid2(int(mWidth*0.5+0.5),
	                          int(mWidth*0.5+0.5));
}

void IAMatchingPoint::move(
			const RRGrid2& dif)
{
	mPosition.setX(mPosition.getX()+dif.getX());	
	mPosition.setY(mPosition.getY()+dif.getY());	
}

//-------------------------------------------------------------------=72
// End of IAMatchingPoint.cpp
//-------------------------------------------------------------------=72
