//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// IAImageTransform.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.1
//
// Modification History:
//  Dec/05/1998:	Created	
//  Feb/27/1999:	Implemented cubic convolution
//
// Bugs:
//
//-------------------------------------------------------------------=72

#ifndef _IA_IMAGE_TRANSFORM_H
#define _IA_IMAGE_TRANSFORM_H

#include "RRProcess.h"
#include "RRFileListData.h"
#include "RRImage.h"
#include "RRField.h"
#include "RRPixelD.h"
#include "IATransformParameterData.h"

class IAImageTransform : public RRProcess
{
  private:

  private:

	RRPixelD mfResampleBilinear(
			const RRField< RRPixelD >& img,
			const double x,
			const double y);
	RRPixelD mfResampleSinc(
			const RRField< RRPixelD >& img,
			const double x,
			const double y);
	RRPixelD mfResample(
			const RRField< RRPixelD >& img,
			const double x,
			const double y);
	double IAImageTransform::mfSinc(
			const double x);
	double mfCubic(
			const double x);

  public:

    IAImageTransform(
			const RRArray< RRData* >& in,	// RRFileListData -> in[0]
											// IATransformParameterData -> in[1]
			RRData *out);	                // RRFileListData

	RRStatus doIt();
};

#endif // _IA_IMAGE_TRANSFORM_H

//-------------------------------------------------------------------=72
// End of IAImageTransform.h
//-------------------------------------------------------------------=72
