//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// IADocUserDefinePart.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.1
//
// Modification History:
//  Dec/05/1998:	Created	
//  Feb/27/1998:	Speed-up
//
// Bugs:
//
//-------------------------------------------------------------------=72

#ifndef _IA_DOC_USER_DEFINE_PART_H
#define _IA_DOC_USER_DEFINE_PART_H

#include "IAMatchingPoint.h"
#include "RRFileName.h"
#include "RRArray.h"
#include "RRField.h"
#include "RRPixelB.h"

class CIADoc;

class IADocUserDefinePart
{
  private:

	RRFileName mReference; // reference image file
	RRFileName mDestination; // destination image file
	RRFileName mDestinationOriginal; // original detination image file
	RRFileName mSave; // file to save destination image

	RRArray< IAMatchingPoint* > mMatchingPoint;

  private:

  	bool mfGetBitmap(
			//const RRField< RRPixelD >& img,
			const RRField< RRPixelB >& img,
			const int xo,
			const int yo,
			const int xs,
			const int ys,
			const int nchan,
			unsigned char *bitmap)const;

  public:

	IADocUserDefinePart();
	~IADocUserDefinePart();	

	bool onOpenDocument(
			LPCTSTR lpszPathName,
			const CIADoc *doc);
	void onFileRefOpen(
			const CIADoc *doc);
	void onRunAlignment(		
			const CIADoc *doc);
	bool onSaveDocument(
			LPCTSTR lpszPathName);		
	bool onFileSave();
	bool onFileSwap(
			const CIADoc *doc);

	bool getRefSize(
			int& xs,
			int& ys,
			int& nchan)const;
	bool getDestSize(
			int& xs,
			int& ys,
			int& nchan)const;

	bool getRefBitmap(
			const int xo,
			const int yo,
			const int xs,
			const int ys,
			const int nchan,
			unsigned char *bitmap)const;
	bool getDestBitmap(
			const int xo,
			const int yo,
			const int xs,
			const int ys,
			const int nchan,
			unsigned char *bitmap)const;

	RRStatus addMatchingPoint(
			IAMatchingPoint *mp);
	RRStatus removeMatchingPoint(
			IAMatchingPoint *mp);
	
};

#endif // _IA_DOC_USER_DEFINE_PART_H

//-------------------------------------------------------------------=72
// End of IADocUserDefinePart.h
//-------------------------------------------------------------------=72
