//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// IADocUserDefinePart.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.1
//
// Modification History:
//  Dec/05/1998:	Created	
//  Feb/27/1998:	Speed-up
//
// Bugs:
//
//-------------------------------------------------------------------=72

#define _IA_DOC_USER_DEFINE_PART_C

#include "stdafx.h"
#include <afxwin.h>         // MFC core and standard components

#include "IADoc.h"
#include "IADocUserDefinePart.h"
#include "IAView.h"
#include "IAPointSearch.h"
#include "IATransParamEstimation.h"
#include "IAImageTransform.h"

#include "RRFileName.h"
#include "RRImageFileIO.h"
#include "RRFiledData.h"
#include "RRDataTemplate.h"

const char *imFile = "img.txt";
const char *mpFile = "mp.txt";
const char *cmpFile = "cmp.txt";
const char *paramFile = "param.txt";
const char *IADUDP_DESTINATION_IMAGE_FILE = "IADUDP.ppm16";

//#define TMP

IADocUserDefinePart::IADocUserDefinePart()
:mReference(),
 mDestination(),
 mDestinationOriginal(),
 mSave()
{}

IADocUserDefinePart::~IADocUserDefinePart()
{}	

bool IADocUserDefinePart::getRefSize(
			int& xs,
			int& ys,
			int& nchan)const
{
	//RRField< RRPixelD > img;
	//if(RRImageFileIO::load(mReference(0),RRIFIO_EXT,RRIFIO_PIXELD,img)==RR_ERROR)
	//		return false;
	RRField< unsigned char > img;
	if(RRImageFileIO::load(&mReference,RRIFIO_EXT,RRIFIO_BYTE_R,img)==RR_ERROR)
			return false;

	img.getSize(xs,ys);
	nchan=4;
	return true;
}

bool IADocUserDefinePart::getDestSize(
			int& xs,
			int& ys,
			int& nchan)const
{
	//RRField< RRPixelD > img;
	//if(RRImageFileIO::load(mDestination(0),RRIFIO_EXT,RRIFIO_PIXELD,img)==RR_ERROR)
	//		return false;
	RRField< unsigned char > img;
	if(RRImageFileIO::load(&mDestination,RRIFIO_EXT,RRIFIO_BYTE_R,img)==RR_ERROR)
			return false;

	img.getSize(xs,ys);
	nchan=4;
	return true;
}

bool IADocUserDefinePart::onOpenDocument(
			LPCTSTR lpszPathName,
			const CIADoc *doc)
{
	mDestination=IADUDP_DESTINATION_IMAGE_FILE;
	mDestinationOriginal=RRFileName(strrchr(lpszPathName,'\\')+1);
	mSave=mDestinationOriginal;

	if(mDestinationOriginal[0]!='\0')
	{
		//RRField< RRPixelD > destorg;
		//if(RRImageFileIO::load(mDestinationOriginal(0),RRIFIO_EXT,RRIFIO_PIXELD,destorg)==RR_ERROR)
		//	return false;
		//if(RRImageFileIO::save(destorg,RRIFIO_PIXELD,RRIFIO_EXT,mDestination(0))==RR_ERROR)
		//	return false;
		RRField< RRPixelS > destorg;
		if(RRImageFileIO::load(&mDestinationOriginal,RRIFIO_EXT,RRIFIO_PIXELS,destorg)==RR_ERROR)
			return false;
		if(RRImageFileIO::save(destorg,RRIFIO_PIXELS,RRIFIO_EXT,&mDestination)==RR_ERROR)
			return false;
	}

	POSITION pos=doc->GetFirstViewPosition();
	if(pos!=NULL)
	{
		CIAView *view=(CIAView*)(doc->GetNextView(pos));
		view->udp.setDestBitmap();
		glDisable(GL_SCISSOR_TEST);
		view->udp.onDraw();
	}

	return true;
}

void IADocUserDefinePart::onFileRefOpen(
			const CIADoc *doc)
{
	CFileDialog dialog(TRUE);
	if(dialog.DoModal()==IDCANCEL)
		return;	
	
	mReference=RRFileName(LPCTSTR(dialog.GetFileName()));

	POSITION pos=doc->GetFirstViewPosition();
	if(pos!=NULL)
	{
		CIAView *view=(CIAView*)(doc->GetNextView(pos));
		view->udp.setRefBitmap();
		glDisable(GL_SCISSOR_TEST);
		view->udp.onDraw();
	}
}

bool IADocUserDefinePart::onSaveDocument(
			LPCTSTR lpszPathName)
{
	mSave=RRFileName(strrchr(lpszPathName,'\\')+1);

	int xs,ys;
	{
		//RRField< RRPixelD > ref;
		//if(RRImageFileIO::load(mReference(0),RRIFIO_EXT,RRIFIO_PIXELD,ref)==RR_ERROR)
		//	return false;
		RRField< unsigned char > ref;
		if(RRImageFileIO::load(&mReference,RRIFIO_EXT,RRIFIO_BYTE_R,ref)==RR_ERROR)
			return false;

		ref.getSize(xs,ys);
	}

	//RRField< RRPixelD > dest;
	//if(RRImageFileIO::load(&mDestination,RRIFIO_EXT,RRIFIO_PIXELD,dest)==RR_ERROR)
	//	return false;
	RRField< RRPixelS > dest;
	if(RRImageFileIO::load(&mDestination,RRIFIO_EXT,RRIFIO_PIXELS,dest)==RR_ERROR)
		return false;

	int dxs,dys;
	dest.getSize(dxs,dys);

	//RRField< RRPixelD > img;
	RRField< RRPixelS > img;

	img.setSize(xs,ys);
	for(int y=0;y<ys;y++)
		for(int x=0;x<xs;x++)
		{
			//RRPixelD pxl;
			//if(x>=dxs || y>=dys)
			//	pxl=RRPixelD(0,0,0,1);
			//else
			//	pxl=dest.getElem(x,y);
			//img.setElem(x,y,pxl);
			RRPixelS pxl;
			if(x>=dxs || y>=dys)
				pxl=RRPixelS(0,0,0,RRPS_MAX);
			else
				pxl=dest.getElem(x,y);
			img.setElem(x,y,pxl);
		}

	//if(RRImageFileIO::save(img,RRIFIO_PIXELD,RRIFIO_EXT,&mSave)==RR_ERROR)
	//	return false;
	if(RRImageFileIO::save(img,RRIFIO_PIXELS,RRIFIO_EXT,&mSave)==RR_ERROR)
		return false;

	return true;
}

bool IADocUserDefinePart::onFileSave()
{
	if(mSave[0]!='\0')
	{
		int xs,ys;
		{
			//RRField< RRPixelD > ref;
			//if(RRImageFileIO::load(mReference(0),RRIFIO_EXT,RRIFIO_PIXELD,ref)==RR_ERROR)
			//	return false;
			RRField< unsigned char > ref;
			if(RRImageFileIO::load(&mReference,RRIFIO_EXT,RRIFIO_BYTE_R,ref)==RR_ERROR)
				return false;

			ref.getSize(xs,ys);
		}

		//RRField< RRPixelD > dest;
		//if(RRImageFileIO::load(&mDestination,RRIFIO_EXT,RRIFIO_PIXELD,dest)==RR_ERROR)
		//	return false;
		RRField< RRPixelS > dest;
		if(RRImageFileIO::load(&mDestination,RRIFIO_EXT,RRIFIO_PIXELS,dest)==RR_ERROR)
			return false;

		int dxs,dys;
		dest.getSize(dxs,dys);

		//RRField< RRPixelD > img;
		RRField< RRPixelS > img;

		img.setSize(xs,ys);
		for(int y=0;y<ys;y++)
			for(int x=0;x<xs;x++)
			{
				//RRPixelD pxl;
				//if(x>=dxs || y>=dys)
				//	pxl=RRPixelD(0,0,0,1);
				//else
				//	pxl=dest.getElem(x,y);
				//img.setElem(x,y,pxl);
				RRPixelS pxl;
				if(x>=dxs || y>=dys)
					pxl=RRPixelS(0,0,0,RRPS_MAX);
				else
					pxl=dest.getElem(x,y);
				img.setElem(x,y,pxl);
			}

		//if(RRImageFileIO::save(img,RRIFIO_PIXELD,RRIFIO_EXT,&mSave)==RR_ERROR)
		//	return false;
		if(RRImageFileIO::save(img,RRIFIO_PIXELS,RRIFIO_EXT,&mSave)==RR_ERROR)
			return false;
	}
	return true;
}

bool IADocUserDefinePart::onFileSwap(
			const CIADoc *doc)
{
	RRFileName tmp=mReference;

	if(mSave[0]!='\0')
	{
		mReference=mSave;
		mSave=RRFileName();
		mDestinationOriginal=tmp;
	}
	else
	{
		mReference=mDestinationOriginal;
		mDestinationOriginal=tmp;
	}

	if(mDestinationOriginal[0]!='\0')
	{
		//RRField< RRPixelD > destorg;
		//if(RRImageFileIO::load(mDestinationOriginal(0),RRIFIO_EXT,RRIFIO_PIXELD,destorg)==RR_ERROR)
		//	return false;
		//if(RRImageFileIO::save(destorg,RRIFIO_PIXELD,RRIFIO_EXT,mDestination(0))==RR_ERROR)
		//	return false;
		RRField< RRPixelS > destorg;
		if(RRImageFileIO::load(&mDestinationOriginal,RRIFIO_EXT,RRIFIO_PIXELS,destorg)==RR_ERROR)
			return false;
		if(RRImageFileIO::save(destorg,RRIFIO_PIXELS,RRIFIO_EXT,&mDestination)==RR_ERROR)
			return false;
	}

	POSITION pos=doc->GetFirstViewPosition();
	if(pos!=NULL)
	{
		CIAView *view=(CIAView*)(doc->GetNextView(pos));
		view->udp.setRefBitmap();
		view->udp.setDestBitmap();
		glDisable(GL_SCISSOR_TEST);
		view->udp.onDraw();
	}

	return true;
}

void IADocUserDefinePart::onRunAlignment(		
			const CIADoc *doc)
{
#ifdef TMP

	RRWOFiledData< RRImageArrayData > imdata(imFile);	
	RRFileListData& imary=(RRFileListData&)(imdata.getSubstance());
	imary.setNumFiles(2);
	imary.setFileName(0,mReference(0));
	imary.setFileName(1,mDestinationOriginal(0));


	RRROFiledData< RRGridArrayData > mpdata("mp.txt");	
	RRROFiledData< RRGridArrayData > cmpdata("cmp.txt");	
	RRArray< RRData* > indata(2);


#else // TMP

	int mpsize=mMatchingPoint.getSize();
	if(mpsize==0)
		return;

	RRWOFiledData< RRFileListData > imdata(imFile);	
	RRWOFiledData< RRGridArrayData > mpdata(mpFile);	
	RRWOFiledData< RRGridArrayData > cmpdata(cmpFile);	

	RRFileListData& imary=(RRFileListData&)(imdata.getSubstance());
	imary.setNumFiles(2);
	imary.setFileName(0,&mReference);
	imary.setFileName(1,&mDestinationOriginal);

// --> not needed

	RRGridArrayData& mpary=(RRGridArrayData&)(mpdata.getSubstance());
	RRArray< RRGrid2 > grid(mMatchingPoint.getSize());
	for(int i=0;i<mMatchingPoint.getSize();i++)
		grid[i]=mMatchingPoint[i]->getPosition();
	mpary.setGridArray(grid);

// --> finding cooresponding points

	RRArray< RRData* > indata(2);
	indata[0]= &imdata;
	indata[1]= &mpdata;

	const int templateSize = mMatchingPoint[0]->getWidth();
	const int searchSize = mMatchingPoint[0]->getWidth();
    IAPointSearch process1(indata,&cmpdata,templateSize,searchSize);
	if(process1.doIt()==RR_ERROR)
			return;

// --> end of fingding corresponding points
#endif // TMP

	indata[0]= &mpdata;
	indata[1]= &cmpdata;
	RRWOFiledData< IATransformParameterData > paramdata(paramFile);	
    IATransParamEstimation process2(indata,&paramdata);
	if(process2.doIt()==RR_ERROR)
			return;
	
	RRDataTemplate< RRFileListData > imd;	
	RRDataTemplate< RRFileListData > rimd;	
	RRFileListData& im=(RRFileListData&)(imd.getSubstance());
	im.setNumFiles(1);
	im.setFileName(0,mDestinationOriginal(0));
	RRFileListData& rim=(RRFileListData&)(rimd.getSubstance());
	rim.setNumFiles(1);
	rim.setFileName(0,&mDestination);

	indata[0]= &imd;
	indata[1]= &paramdata;
    IAImageTransform process3(indata,&rimd);
	if(process3.doIt()==RR_ERROR)
			return;
	
	//mDestination=mReference;

	POSITION pos=doc->GetFirstViewPosition();
	if(pos!=NULL)
	{
		CIAView *view=(CIAView*)(doc->GetNextView(pos));
		view->udp.setDestBitmap();
		glDisable(GL_SCISSOR_TEST);
		view->udp.onDraw();
	}
}

bool IADocUserDefinePart::mfGetBitmap(
			//const RRField< RRPixelD >& img,
			const RRField< RRPixelB >& img,
			const int xo,
			const int yo,
			const int xs,
			const int ys,
			const int nchan,
			unsigned char *bitmap)const
{
	int rxs,rys;
	img.getSize(rxs,rys);
	
	if(rxs==0 || rys==0)
		return false; 

	int i=0;
	for(int y=0;y<ys;y++)
		for(int x=0;x<xs;x++)
		{
			int rx=xo+x;
			int ry=yo+y;

			unsigned char v[4];
			if(rx<0 || rx>=rxs || ry<0 || ry>=rys)
				v[0]=v[1]=v[2]=v[3]=0;
			else
			{
				//RRPixelD p=img.getElem(rx,ry);
				//v[0]=unsigned char(p.getR()*255+0.5);			
				//v[1]=unsigned char(p.getG()*255+0.5);			
				//v[2]=unsigned char(p.getB()*255+0.5);			
				//v[3]=unsigned char(0.5*255+0.5);
				RRPixelB p=img.getElem(rx,ry);
				v[0]=p.getR();			
				v[1]=p.getG();			
				v[2]=p.getB();			
				v[3]=128;
			}

			switch(nchan)
			{
			  case 4:
				bitmap[i]=v[0];
				bitmap[i+1]=v[1];
				bitmap[i+2]=v[2];
				bitmap[i+3]=v[3];
				i+=4;
				break;
			  case 3:
				bitmap[i]=v[0];
				bitmap[i+1]=v[1];
				bitmap[i+2]=v[2];
				i+=3;
				break;
			  case 1:
				bitmap[i]=(v[0]+v[1]+v[2])/3;
				i++;
				break;
			}
		}	
	
	return true;
}

bool IADocUserDefinePart::getRefBitmap(
			const int xo,
			const int yo,
			const int xs,
			const int ys,
			const int nchan,
			unsigned char *bitmap)const
{
	//RRField< RRPixelD > ref;
	//if(RRImageFileIO::load(&mReference,RRIFIO_EXT,RRIFIO_PIXELD,ref)==RR_ERROR)
	//	return false;
	RRField< RRPixelB > ref;
	if(RRImageFileIO::load(&mReference,RRIFIO_EXT,RRIFIO_PIXELB,ref)==RR_ERROR)
		return false;
	return mfGetBitmap(ref,xo,yo,xs,ys,nchan,bitmap);
}

bool IADocUserDefinePart::getDestBitmap(
			const int xo,
			const int yo,
			const int xs,
			const int ys,
			const int nchan,
			unsigned char *bitmap)const
{
	//RRField< RRPixelD > dest;
	//if(RRImageFileIO::load(mDestination(0),RRIFIO_EXT,RRIFIO_PIXELD,dest)==RR_ERROR)
	//	return false;
	RRField< RRPixelB > dest;
	if(RRImageFileIO::load(&mDestination,RRIFIO_EXT,RRIFIO_PIXELB,dest)==RR_ERROR)
		return false;
	return mfGetBitmap(dest,xo,yo,xs,ys,nchan,bitmap);
}

RRStatus IADocUserDefinePart::addMatchingPoint(
			IAMatchingPoint *mp)
{
	mMatchingPoint.insert(0,mp);
	return RR_SUCCESS;
}

RRStatus IADocUserDefinePart::removeMatchingPoint(
			IAMatchingPoint *mp)
{
	for(int i=0;i<mMatchingPoint.getSize();i++)
	{
		if(mMatchingPoint[i]==mp)
		{
			mMatchingPoint.remove(i);
			return RR_SUCCESS;
		}
	}
	return RR_ERROR;
}

//-------------------------------------------------------------------=72
// End of IADocUserDefinePart.cpp
//-------------------------------------------------------------------=72
