//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// IABitmap.cpp
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.0
//
// Modification History:
//  Dec/05/1998:	Created	
//
// Bugs:
//
//-------------------------------------------------------------------=72

#include "stdafx.h"

#include "IABitmap.h"

IABitmap::IABitmap()
:WGLObject(),
 mRefBitmap(),
 mDestBitmap(),
 mMode(IAB_BLEND)
{}

IABitmap::IABitmap(
			const IABitmap& x)
:WGLObject(x),
 mRefBitmap(x.mRefBitmap),
 mDestBitmap(x.mDestBitmap),
 mMode(x.mMode)
{}

IABitmap::~IABitmap()
{}

const IABitmap& IABitmap::operator=(
			const IABitmap& x)
{
	WGLObject::operator=(x);
	mRefBitmap=x.mRefBitmap;
	mDestBitmap=x.mDestBitmap;
	mMode=x.mMode;
	return *this; 
}

bool IABitmap::setRefBitmap(
			const CIADoc *doc)
{
	int xs,ys,depth;
	doc->udp.getRefSize(xs,ys,depth);
	unsigned char *bmp = new unsigned char[xs*ys*depth];

	if(doc->udp.getRefBitmap(0,0,xs,ys,depth,bmp)==false)
	{
		delete[] bmp;
		return false;
	}

	RRBoundingBox bbox(RRGrid2(0,0),RRGrid2(xs,ys),0);
	mRefBitmap=WGLBitmap(bbox,depth,bmp);
	delete[] bmp;
	return true;
}

bool IABitmap::setDestBitmap(
			const CIADoc *doc)
{
	int xs,ys,depth;
	doc->udp.getDestSize(xs,ys,depth);
	unsigned char *bmp = new unsigned char[xs*ys*depth];

	if(doc->udp.getDestBitmap(0,0,xs,ys,depth,bmp)==false)
	{
		delete[] bmp;
		return false;
	}

	RRBoundingBox bbox(RRGrid2(0,0),RRGrid2(xs,ys),0);
	mDestBitmap=WGLBitmap(bbox,depth,bmp);
	delete[] bmp;
	return true;
}

bool IABitmap::renderObject()const
{
	glPushMatrix();
	{
		switch(mMode)
		{
		  case IAB_REF:
			glDisable(GL_BLEND);
			mRefBitmap.renderObject();
			break;
		  case IAB_DEST:
			glDisable(GL_BLEND);
			mDestBitmap.renderObject();
			break;
		  case IAB_BLEND:
			glEnable(GL_BLEND);
			glBlendFunc(GL_ONE,GL_ZERO);
			mRefBitmap.renderObject();
			glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
			mDestBitmap.renderObject();
			break;
		}
	}
	glPopMatrix();

	return true;
}

//-------------------------------------------------------------------=72
// End of IABitmap.cpp
//-------------------------------------------------------------------=72
