//-------------------------------------------------------------------=72
//
// Copyright (C) Columbia University, 1998-1999. All Rights Reserved.
//
//-------------------------------------------------------------------=72
//
// IABitmap.h
//
//-------------------------------------------------------------------=72
//
// Author:				 Tomoo Mitsunaga
//
// Version:              1.1
//
// Modification History:
//  Dec/05/1998:	Created	
//  Feb/27/1999:	Modified setRefBitmap(),setRefBitmap()
//
// Bugs:
//
//-------------------------------------------------------------------=72

#ifndef _IA_BITMAP_H
#define _IA_BITMAP_H

#include "WGLBitmap.h"

#include "IADoc.h"

typedef enum
{
	IAB_REF,
	IAB_DEST,
	IAB_BLEND
} IABitmapMode;

class IABitmap : public WGLObject
{
  private:

	WGLBitmap mRefBitmap;
	WGLBitmap mDestBitmap;
	IABitmapMode mMode;

  public:

	IABitmap();
	IABitmap(const IABitmap& x);
	virtual ~IABitmap();
	
	const IABitmap& operator=(const IABitmap& x);

	bool setRefBitmap(const CIADoc *doc);
	bool setDestBitmap(const CIADoc *doc);

	IABitmapMode getMode()const{return mMode;}
	void setMode(
			const IABitmapMode mode){mMode=mode;}

	virtual bool renderObject()const;
};

#endif // _IA_BITMAP_H

//-------------------------------------------------------------------=72
// End of IABitmap.h
//-------------------------------------------------------------------=72
